<script type="text/javascript">
    $.ajaxSetup({
        headers: {
            'Accept': 'application/json',
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

            
    $(document).ajaxError(function(e, xhr, settings) {
        
        if(!(xhr && xhr.readyState === 4)) {
            return;
        }

        var response = false;
        var message = '<?php echo app('translator')->get("Došlo je do greške u komunikaciji sa serverom!"); ?>';
        
        if(!xhr.responseText) {
            <?php if(env('APP_DEBUG')): ?>
                let errId = Math.floor(Math.random() * Math.floor(1000000));
                console.log(errId + ": Greška. 'xhr' objekat je neispravno formiran.\
                                    'responseText' nije setovan. Error trace:");
                console.log(e);
                console.log(errId + ": 'xhr' objekat: ");
                console.log(xhr);
                console.log(errId + ': End error trace.');
            <?php endif; ?>
        }
        else {
            try {
                response = JSON.parse(xhr.responseText);
            } catch(err) {
                <?php if(env('APP_DEBUG')): ?>
                    let errId = Math.floor(Math.random() * Math.floor(1000000));
                    console.log(errId + ': Greška prilikom poziva JS funkcije \
                                        JSON.parse(). Error trace:');
                    console.log(err);
                    console.log(errId + ":'xhr' objekat: ");
                    console.log(xhr);
                    console.log(errId + ': End error trace.')
                <?php endif; ?>
            }
        }

        console.log(response);
        
        if (response && response['message']) {
            message = response['message'];
        }

        <?php if(env('APP_DEBUG')): ?>
            showSystemMessage(message, 'error');
        <?php else: ?> 
            if(xhr && xhr.status !== 422)  {
                showSystemMessage(message, 'error');
            }
        <?php endif; ?>
    });
    
    $(document).ajaxSuccess(function(e, xhr, settings) {
//        DEBUG
//        if(!(xhr && xhr.readyState === 4)) {
//            return;
//        }

        var response = false;
        var message = '';
        
        if(xhr.responseText) {
            try {
                response = JSON.parse(xhr.responseText);
            } catch(err) {
                let errId = Math.floor(Math.random() * Math.floor(1000000));
                console.log(errId + ': Greška prilikom poziva JS funkcije \
                                     JSON.parse(). Error trace:');
                console.log(err);
                console.log(errId + ":'xhr' objekat: ");
                console.log(xhr);
                console.log(errId + ': End error trace.')
            }
        }
        
        if (response && response['message']) {
            message = response['message'];
        }
        
        if(message){
            showSystemMessage(message, 'success');
        }
    });
</script><?php /**PATH /opt/cms/resources/views/_layout/partials/ajax.blade.php ENDPATH**/ ?>