<?php

namespace App\Http\Controllers;

//change the request class if needed

use Akaunting\Setting\Drivers\Json;
use Illuminate\Http\Request as Request;
use App\Models\PDF as Entity;
use Illuminate\Validation\Rule;
use Yajra\DataTables\DataTables;
use App\Http\Resources\JsonResource;
use Illuminate\Http\File;
use PDF;
use Artisan;

class PdfController extends Controller
{

    protected $namespace = 'pdf.';

    // public function generatePDF()
    // {
    //     Artisan::call('serve', [
    //         '--host' => '127.0.0.1',
    //         '--port' => '8000',
    //     ]);

    //     $data = [ 
    //         ['kolona1' => 'Podatak 1', 'kolona2' => 'Podatak 2', 'kolona3' => 'Podatak 3'],
    //         ['kolona1' => 'Podatak 4', 'kolona2' => 'Podatak 5', 'kolona3' => 'Podatak 6'],
    //         ['kolona1' => 'Podatak 7', 'kolona2' => 'Podatak 8', 'kolona3' => 'Podatak 9'],
    //         ['kolona1' => 'Podatak 10', 'kolona2' => 'Podatak 11', 'kolona3' => 'Podatak 12'],
    //         ['kolona1' => 'Podatak 13', 'kolona2' => 'Podatak 14', 'kolona3' => 'Podatak 15'],
    //     ];

    //     $pdf = PDF::loadView('pdf', compact('data'));
        
    //     return $pdf->download('tabela.pdf');
    // }

    public function generatePDF(Request $request)
    {
        $data = $request->input('data');

        // Generišite PDF koristeći podatke
        $pdf = PDF::loadView('pdf', compact('data'));
        
        // Sačuvajte PDF na server i vratite URL ka njemu
        $pdf->download('tabela.pdf');
        
        return response()->json(['url' => asset('tabela.pdf')]);
    }

    public function index()
    {

        return view($this->namespace . 'index', [
            'entity' => new Entity(),
            'namespace' => $this->namespace
        ]);
    }

    public function store()
    {

        $entity = new Entity;

        $data = request()->validate(self::rulesStore($entity));

        $entity->fill($data);

        $entity->save();

        $this->handleUploadedFile($entity);
        $this->handleUploadedImage($entity);

        if (request()->wantsJson()) {
            return JsonResource::make()->withSuccess(__('PDF je uspešno sačuvan!'));
        }

        return redirect()->route($this->namespace . 'index')->withSystemSuccess(__('PDF je uspešno sačuvan!'));
    }

    public function edit(Entity $entity)
    {
        return view($this->namespace . 'edit', [
            'entity' => $entity,
            'namespace' => $this->namespace
        ]);
    }

    public function update(Entity $entity)
    {
        $data = request()->validate(self::rulesUpdate($entity));

        $entity->fill($data);

        $entity->save();

        $this->handleUploadedFile($entity);
        $this->handleUploadedImage($entity);

        if (request()->wantsJson()) {
            return JsonResource::make()->withSuccess(__('PDF je uspešno editovan!'));
        }

        return redirect()->route($this->namespace . 'index')->withSystemSuccess(__('PDF je uspešno editovan!'));;
    }

    public function delete(Entity $entity)
    {

        $entity->delete();

        if (request()->wantsJson()) {
            return JsonResource::make()->withSuccess(__('PDF je uspešno obrisan!'));
        }

        return redirect()->route($this->namespace . 'index')->withSystemSuccess(__('PDF je uspešno obrisan!'));
    }



    public function datatable()
    {

        $entity = request()['entityId'];

        $entities = Entity::query();

        if ($entity) {
            $entities->where('id', '<>', $entity);
        }

        $entities->get();

        $datatable = datatables($entities)->addColumn('actions', function ($entity) {
            return view($this->namespace . 'partials.table.actions', [
                'entity' => $entity,
                'namespace' => $this->namespace
            ]);
        })->addColumn('ban', function ($entity) {
            return view('_layout.partials.table.active_inactive', [
                'entity' => $entity,
                'namespace' => $this->namespace,
                'active' => $entity->isActive()
            ]);
        });

        $datatable->rawColumns(['actions', 'ban']);

        return $datatable->make(true);
    }

    public function changeActive(Entity $entity)
    {
        $entity->ban = $entity->ban == 1 ? 0 : 1;

        $entity->save();

        $status = $entity->isActive() ? 'aktiviran' : 'deaktiviran';

        if (request()->wantsJson()) {
            return JsonResource::make()->withSuccess(__('PDF je uspešno ' . $status . '!'));
        }

        return redirect()->route($this->namespace . 'index')->withSystemSuccess(__('PDF je uspešno ' . $status . '!'));
    }

    protected function handleUploadedFile(Entity $entity)
    {
        if (request()->hasFile('pdf_file')) {

            $path = public_path('/data/pdf-files/');

            if (!\File::exists($path)) {

                \File::makeDirectory($path);

                $path = public_path('/data/pdf-files/');
            }

            $pdfFile = request()->file('pdf_file');
            $newPDFfileName = \Str::slug($entity->name) . '-' . $entity->id . '.' .  $pdfFile->getClientOriginalExtension();
            $pdfFile->move(
                $path,
                $newPDFfileName
            );
            $localPath = '/data/pdf-files/';
            $entity->file_path = $localPath . $newPDFfileName;

            $entity->save();
        }
    }

    protected function handleUploadedImage(Entity $entity)
    {
        if (request()->hasFile('image')) {

            $path = public_path('/data/pdf-lead-images/');

            if (!\File::exists($path)) {

                \File::makeDirectory($path);

                $path = public_path('/data/pdf-lead-images/');
            }

            $photoFile = request()->file('image');
            $newPhotoFileName = \Str::slug($entity->name) . '-' . $entity->id . '.' .  $photoFile->getClientOriginalExtension();
            $photoFile->move(
                $path,
                $newPhotoFileName
            );
            $localPath = '/data/pdf-lead-images/';
            $entity->image = $localPath . $newPhotoFileName;

            $entity->save();
        }
    }

    protected function rulesStore($entity)
    {   
        $rules = [
            'name' => ['required', 'string', 'max:255'],
            'image' => ['required', 'file', 'image'],
            'pdf_file' => ['nullable', 'file', 'mimes:pdf']
        ];

        return $rules;
    }
    protected function rulesUpdate($entity)
    {   
        $rules = [
            'name' => ['required', 'string', 'max:255'],
            'image' => ['nullable', 'file', 'image'],
            'pdf_file' => ['nullable', 'file', 'mimes:pdf']
        ];

        return $rules;
    }
}
