<?php

namespace App\Http\Controllers\Traits;

use App\Models\PollIntext as Entity;
use Illuminate\Http\Request;
use App\Http\Resources\JsonResource;
use Illuminate\Support\Facades\Validator;
use App\Http\Resources\Select2\PollIntext as PollIntext;

trait PollIntextTrait
{
    /**
     * This ajax method returns records from 'polls_intext' table
     * 
     * @return JSON
     */
    public function getPollIntexts()
    {
        //Napraviti logiku dovlacenja svih aktivnih intext anketa

        $entities = Entity::query()->where('ban', 0)->get();

        $entities = PollIntext::collection($entities);

        return $entities;
    }

    /**
     * This ajax method returns filtered record from 'polls_intext' table
     * 
     * @return JSON
     */
    public function getOnePollIntext(Request $request)
    {
        //Napraviti logiku dovlacenja jedne ankete ciji je id prosledjen kroz request

        $data = $request->validate([
            'entityId' => ['required', 'exists:polls_intext,id']
        ]);

        $entity = Entity::findOrFail($data['entityId']);

        return $entity->toJson();
    }

    /**
     * This ajax method create new record in 'polls_intext' table
     * 
     * @return JSON
     */
    public function savePollIntext(Request $request)
    {
        //Napraviti logiku suvanja jedne ankete dospele iz requesta i vracanja te ankete nazad

        $data = $this->validatePollIntexts($request);

        $entity = new Entity;

        $newDateFrom = date('Y-m-d', strtotime($data['date_from']));
        $newDateTo = date('Y-m-d', strtotime($data['date_to']));

        $data['date_from'] = $newDateFrom;
        $data['date_to'] = $newDateTo;
        $data['answers'] = isset($data['answers']) ?  implode('###', $data['answers']) . '###' : '';
        $data['votes'] = isset($data['votes']) ?  implode('###', $data['votes']) . '###' : '';

        $data['created_at'] = date('Y-m-d H:i:s');
        $data['updatet_at'] = date('Y-m-d H:i:s');
        $data['created_by'] = \Auth::user()->id;
        $data['updatet_by'] = \Auth::user()->id;

        //proveriti da li treba site_id
        $data['site_id'] = 0;

        $entity->fill($data);

        $entity->save();

        return JsonResource::make(['entityId' => $entity->id])->withSuccess(__('Anketa je uspešno sačuvana!'));

    }

    /**
     * This ajax method update record in 'polls_intext' table
     * 
     * @return JSON
     */
    public function updatePollIntext(Request $request)
    {
        //Napraviti logiku update-a jedne ankete dospele iz requesta i vracanja te ankete nazad
        //dd($request->all());
        $data = $this->validatePollIntexts($request);

        $entity = Entity::findOrFail($data['entityId']);

        unset($data['entityId']);

        $newDateFrom = date('Y-m-d', strtotime($data['date_from']));
        $newDateTo = date('Y-m-d', strtotime($data['date_to']));

        $data['date_from'] = $newDateFrom;
        $data['date_to'] = $newDateTo;
        $data['answers'] = isset($data['answers']) ?  implode('###', $data['answers']) . '###' : '';
        $data['votes'] = isset($data['votes']) ?  implode('###', $data['votes']) . '###' : '';

        $data['created_at'] = date('Y-m-d H:i:s');
        $data['updatet_at'] = date('Y-m-d H:i:s');
        $data['created_by'] = \Auth::user()->id;
        $data['updatet_by'] = \Auth::user()->id;

        //proveriti da li treba site_id
        $data['site_id'] = 0;

        $entity->fill($data);

        $entity->save();

        return JsonResource::make(['entityId' => $entity->id])->withSuccess(__('Anketa je uspešno izmenjena!'));
    }

    protected function validatePollIntexts($request)
    {
        $data = $request->validate([
            'entityId' => ['nullable', 'exists:polls_intext,id'],
            'date_from' => ['required', 'date'],
            'date_to' => ['required', 'date', 'after_or_equal:date_from'],
            'question' => ['required', 'string', 'max:255'],
            'answers' => ['required', 'array'],
            'answers.*' => ['required', 'string', 'max:1000'],
            'votes' => ['required', 'array'],
            'votes.*' => ['nullable', 'numeric'],
        ]);

        return $data;
    }
}