<?php

namespace App\Http\Controllers;

//change the request class if needed
use Illuminate\Http\Request as Request;

use App\Models\Truck\Company as Entity;
use App\Models\Website\Website;

use Junges\ACL\Models\Group;

use App\Http\Resources\Select2\Role;
use Illuminate\Validation\Rule;

use App\Http\Resources\JsonResource;
use Illuminate\Support\Carbon;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Facades\Auth;

class TruckCompaniesController extends Controller 
{
    protected $request;
    
    public function __construct(Request $request)
    {
        $this->request = $request;

    }
    
    public function index()
    {   
        return view('truck.companies.index');
    }
    
    /*
     * Yajrabox datatables metod
     */
    public function datatable()
    {
        $query = Entity::query()->where('id', '>', 0)->orderBy('created_at', 'desc');

        return datatables($query)
            ->addColumn('actions', function ($entity) {
                return view('truck.companies.partials.table.actions', 
                            ['entity' => $entity]);
            })
            ->editColumn('phone', function ($entity) {
                return $entity-> phone ? $entity->phone : '---';
            })
           
            ->rawColumns(['actions', 'image'])
            ->setRowAttr([
                'data-id' => function($entity) {
                    return $entity->id;
                }
            ])
            ->make(true);
    }
    
    public function create()
    {   
        $entity = new Entity();
        
        return view('truck.companies.create', [
            'entity' => $entity,
        ]);
    }
    
    public function store()
    {   
        $request = $this->request;
        
        
        $data = $request->validate([
            'name' => ['required', 'string', 'max:190'],
            'address' => ['required', 'string', 'max:100'],
            'email' => ['required', 'email', 'max:100', 'unique:truck_companies,email'],
            'phone' => ['required', 'string', 'max:15'],
            'jib' => ['required', 'string', 'max:20'],
            'currency' => ['required', 'string', 'max:3']
        ]);

        $entity = new Entity();
        
        $entity->fill($data);
        $entity->save();
        
        
        if ($request->wantsJson()) {
            return JsonResource::make()->withSuccess(__('Firma je uspešno sačuvana!'));
        }
        
        return redirect()->route('truck.companies')->withSystemSuccess(__('Firma je uspešno sačuvana!'));
    }
    
    public function edit(Entity $entity)
    {
            return view('truck.companies.edit', [
            'entity' => $entity,
        ]);
    }
    
    public function update(Entity $entity)
    {
        $request = $this->request;
        
        $data = $request->validate([
            'name' => ['required', 'string', 'max:190'],
            'address' => ['required', 'string', 'max:100'],
            'email' => ['required', 'email', 'max:100'],
            'phone' => ['required', 'string', 'max:15'],
            'jib' => ['required', 'string', 'max:20'],
            'currency' => ['required', 'string', 'max:3']
        ]);
        
        $entity->fill($data);
        $entity->save();
        
        if ($request->wantsJson()) {
            return JsonResource::make()->withSuccess(__('Firma je uspešno izmenjena!'));
        }
        
        return redirect()->route('truck.companies')->withSystemSuccess(__('Firma je uspešno izmenjena!'));
    }
    
    public function delete(Entity $entity)
    {
        $entity->delete();
        
        if ($this->request->wantsJson()) {
            return JsonResource::make()->withSuccess(__('Firma je uspešno obrisana!'));
        }
        
        return redirect()->route('truck.companies.index')->withSystemSuccess(__('Firma je uspešno obrisana!'));
    }

}
