<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class SettingsRequest extends FormRequest
{
    /**
     * Autorizacija se izvrsava preko 'middleware'-a. Zato je setovano 'true' 
     * kao povratna vrednost.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Validaciona pravila za akcije novi/izmeni kontrolera WebsitesController
     *
     * @return array
     */
    public function rules()
    {
        $imageRules = \App\Models\Image::getImageValidationRules();
        
        $website = $this->route('entity');
        
        return [
            'newscms.title' => ['nullable', 'string', 'max:180'],
            'newscms.pib' => ['nullable', 'numeric', 'digits_between:5,9'],
            'newscms.identification_number' => ['nullable', 'numeric', 'digits_between:5,9'],
            'newscms.post_number' => ['nullable', 'string', 'max:180'],
            'newscms.city' => ['nullable', 'string', 'max:180'],
            'newscms.address' => ['nullable', 'string', 'max:180'],
            'newscms.email' => ['nullable', 'email', 'max:180'],
            'newscms.phone' => ['nullable', 'string', 'max:180'],
            'newscms.mobile_phone' => ['nullable', 'string', 'max:180'],
            
            'newscms.logo' => array_merge($imageRules, [Rule::dimensions()->minWidth(500)->minHeight(500)]),
            'newscms.app_logo' => array_merge($imageRules, [Rule::dimensions()->minWidth(500)->minHeight(500)]),
            'newscms.icon' => array_merge($imageRules, [Rule::dimensions()->minWidth(100)->minHeight(100)]),
        ];
    }
}
