<?php

namespace App\Http\Requests\Podesavanja;

use Illuminate\Foundation\Http\FormRequest;

use Illuminate\Validation\Rule;


class ProfilRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return TRUE;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $imageRules = \App\Models\Image::getImageValidationRules();

        return [
            'first_name' => ['required', 'string', 'max:190'],
            'last_name' => ['required', 'string', 'max:190'],
            'email' => ['required', 'email', 'max:190'],
            'phone' => ['nullable', 'string', 'max:190'],
            'slika_profil' => array_merge($imageRules, [Rule::dimensions()->minWidth(100)->minHeight(100)]),
        ];
    }

}
