<?php

namespace App\Imports;

use App\Models\TvScheme;
use Carbon\Carbon;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use PhpOffice\PhpSpreadsheet\Shared\Date;

class TvSchemeImport implements ToCollection, WithHeadingRow
{
    private $day;

    public function __construct($day)
    {
        $this->day = $day;
    }
    public function collection(Collection $rows)
    {
        $content = [];
        $vremeEmitovanja = 0;
        foreach ($rows as $key => $row){
            //preskace red ako nema vreme emitovanja
            if(empty($row['vreme_emitovanja'])){
                continue;
            }
            if ($key == 0){
                //prvi red dolazi kao double
                $vremeEmitovanja = $row['vreme_emitovanja'];
            }
            else{
                //drugi red pa na dalje dolazi kao string i potrebno ga je sabirati sa trajanjem da bi se dobilo novo vreme emitovanja
                //prvi red trajanja dolazi kao string i potrebno ga je pretvoriti u double radi sabiranja
                if (gettype($rows[$key-1]['trajanje']) == 'string'){
                    $time = explode(":",$rows[$key-1]['trajanje']);
                    $minutes = intval($time[0])*60 + intval($time[1]);
                    $dayMinutes = 1440;
                    $rows[$key-1]['trajanje2'] = ($minutes * 1) / ($dayMinutes);
                }
                $rows[$key]['vreme_emitovanja'] = $vremeEmitovanja + $rows[$key - 1]['trajanje2'];
                $vremeEmitovanja = $row['vreme_emitovanja'];
            }
            $row['vreme_emitovanja'] = Carbon::parse(Date::excelToDateTimeObject($row['vreme_emitovanja']))->format('H:i');
            $row['trajanje'] = Carbon::parse(Date::excelToDateTimeObject($row['trajanje']))->format('H:i');
            //skidanje praznina i redova iz stringa
            $row['emisije'] = trim(preg_replace('/\r|\n/', ' ', $row['emisije']));
//            dd($row['emisije']);

                $content[$row['vreme_emitovanja']] = [
                    'content'       => $row['emisije'],
                    'time'          => $row['vreme_emitovanja'],
                    'duration'      => $row['trajanje'],
                    'vreme_emitovanja' => $row['vreme_emitovanja']
                ];
        }

        $entityExists = TvScheme::where('day', $this->day)->first();

        if ($entityExists) {
            $entityExists->content = json_encode($content);
             $entityExists->save();
        }
        else {
             TvScheme::create([
                'day'   => $this->day,
                'content' => json_encode($content)
            ]);
        }
    }
}
