<?php

namespace App\ViewComposers;

use Illuminate\View\View;
use App\Models\Website\Website;

class LayoutPartialsNavbarWebsites
{
    public function compose(View $view)
    {
        $this->addWebsites($view);
    }

    protected function addWebsites(View $view)
    {
        $user = auth()->user();
        if (!$user) {
            return;
        }
        
        $view->with([
            'websites' => $user->getWebsites(),
            'primaryWebsite' => $user->getPrimaryWebsite(),
        ]);
    }
}