<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class NewPermissionsSeeder extends Seeder
{

    private $tableName = 'permissions';
    private $newAclPermissions = [
        'novel-of-the-year',
        'juries',
        'pdf',
        'printed-editions-en'
    ];
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        foreach ($this->newAclPermissions as $permission) {
            $foundPermission = DB::table($this->tableName)->where('name', $permission)->get();
            if ($foundPermission->isEmpty()) {
                DB::table($this->tableName)->insert([
                    'name' => $permission,
                    'guard_name' => 'web',
                    'description' => 'Omoguvaca rad sa ' . $permission,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        }
    }
}
