/*
* Embed Media Dialog based on http://www.fluidbyte.net/embed-youtube-vimeo-etc-into-ckeditor
*
* Plugin name:      mediaembed
* Menu button name: MediaEmbed
*
* Youtube Editor Icon
* http://paulrobertlloyd.com/
*
* @author Fabian Vogelsteller [frozeman.de]
* @version 0.5
*/
( function() {
    CKEDITOR.plugins.add( 'relatedNews', {
        icons: 'relatedNewsIcon', // %REMOVE_LINE_CORE%
        hidpi: true, // %REMOVE_LINE_CORE%
        init: function(editor) {
            var relatedNews = this;
            var relatedNewsModal = getRelatedArticlesModal();

            editor.addCommand('relatedNews', {
                exec: function(editor) {
                    let galleryContainerHtml = `</p><p><img alt="" rln_id="relatedNews" src="/custom/ckeditor/plugins/relatedNews/icons/mlg.png" width="100%" relatedNews></p>`;
                    editor.insertHtml(galleryContainerHtml);
                }
            });

            editor.addCommand('wrapToText', {
                exec: function(editor) {
                    var selectedElement = editor.getSelection().getStartElement();
                    if (!selectedElement) {
                        return;
                    }
                    var parents = selectedElement.getParents();
                    var done = false;
                    console.log(selectedElement, parents);

                    for (var index in parents){
                        if(parents[index].getName() == 'p'){
                            done = true
                            var previousElement = parents[index].getPrevious();
                            var nextElement = parents[index].getNext();
                            while(previousElement !== null && previousElement.getHtml() == "<br>"){
                                previousElement.remove();
                                previousElement = parents[index].getPrevious();
                            }
                            while(nextElement !== null && nextElement.getHtml() == "<br>"){
                                nextElement.remove();
                                nextElement = parents[index].getNext();
                            }
                            console.log(parents[index]);
                        }
                    }

                    if(!done){
                        var previousElement = selectedElement.getPrevious();
                        var nextElement = selectedElement.getNext();
                        while(previousElement !== null && previousElement.getHtml() == "<br>"){
                            previousElement.remove();
                            previousElement = selectedElement.getPrevious();
                        }
                        while(nextElement !== null && nextElement.getHtml() == "<br>"){
                            nextElement.remove();
                            nextElement = selectedElement.getNext();
                        }
                    }

                    editor.focus();
                }
            });

            editor.ui.addButton( 'RelatedNews', {
                label: 'Pozicije za povezane vesti',
                command: 'relatedNews',
                icon: 'relatedNewsIcon',
                toolbar: 'relatedNews'
            });

            if (editor.contextMenu) {
                editor.addMenuGroup('relatedNews');

                editor.contextMenu.addListener(function(element, selection) {
                    console.log(element);
                    if (element.hasAttribute('relatedNews')) {
                        console.log(editor);
                        editor.contextMenu.removeAll();
                        editor.addMenuItems({
                            DeleteLatestDiv: {
                                label : 'Obriši okvir',
                                command : 'deleteLatestEmbedResponsive',
                                group : 'relatedNews',
                                order : 2
                            },
                            WrapToText: {
                                label : 'Wrap to text',
                                command : 'wrapToText',
                                group : 'relatedNews',
                                order : 3
                            }
                        });

                        return {
                            DeleteLatestDiv: CKEDITOR.TRISTATE_ON,
                            WrapToText: CKEDITOR.TRISTATE_ON
                        };
                    }

                    if (selection.getType() == CKEDITOR.SELECTION_TEXT) {
                        editor.addMenuItems({
                            RelatedNewsLink: {
                                label : 'Pozicije za povezane vesti',
                                icon: 'relatedNewsIcon',
                                command : 'relatedNews',
                                group : 'relatedNews',
                                order : 98
                            }
                        });

                        return {
                            RelatedNewsLink: CKEDITOR.TRISTATE_OFF
                        };
                    } else if (selection.getType() == CKEDITOR.SELECTION_NONE) {
                        editor.addMenuItems({
                            RelatedNews: {
                                label : 'Ubaci Link Za Povezanu Vest',
                                icon: 'relatedNewsIcon',
                                command : 'relatedNews',
                                group : 'relatedNews',
                                order : 98
                            }
                        });

                        return {
                            RelatedNews: CKEDITOR.TRISTATE_OFF
                        };
                    }
                });
            }
        }
    });
})();
