@push('head_links')
<style>
    .newscms-datepicker {
        background-color: white !important;
    }
    .newscms-datepicker:disabled {
        background-color: whitesmoke !important;
        color: gray !important;
    }
    .newscms-hoverify {
        background-color: #459de5 !important;
        cursor: pointer;
    }
    .newscms-dp-enabled {
        background-color: aqua !important;
    }
</style>
@endpush

@php
    $id = $id ?? ( 'datum-' . rand(1000, 9999) );
@endphp

<div class="input-group">
    <input type="hidden" 
        id="{{ $id }}"
        name="{{ $name ?? ($name = 'datum') }}"
        value="{{ $value ?? ( isset($autoset) && $autoset ? now()->format('Y-m-d') : '' ) }}"
    >
    <input 
        type="text"
        class="form-control @errorClass($name, 'is-invalid')"
        id="{{ 'dp-' . $id }}"
        placeholder="{{ $placeholder ?? __('Izaberite datum') }}"
        value="{{ isset($value) ? \Carbon\Carbon::parse($value)->format('d.m.Y') : ( isset($autoset) && $autoset ? now()->format('d.m.Y') : '') }}"
        @if(isset($readonly) && $readonly) readonly @endif
        @if(isset($disabled) && $disabled) disabled @endif
    >
    <div class="input-group-append">
        <span class="input-group-text bg-custom text-white b-0"><i class="mdi mdi-calendar"></i></span> <!-- mdi-border-color-->
    </div>
</div>

@push('footer_scripts')
<script>

/* PROMENA JEZIKA ZA DATEPICKER - NEUSPESNO sa datepicker.config('locale' i 'language') ! 
$(function() {
    $.fn.datepicker.dates['sr-latin'] = {
        days: ["Nedelja","Ponedeljak", "Utorak", "Sreda", "Četvrtak", "Petak", "Subota"],
        daysShort: ["Ned", "Pon", "Uto", "Sre", "Čet", "Pet", "Sub"],
        daysMin: ["N", "Po", "U", "Sr", "Č", "Pe", "Su"],
        months: ["Januar", "Februar", "Mart", "April", "Maj", "Jun", "Jul", "Avgust", "Septembar", "Oktobar", "Novembar", "Decembar"],
        monthsShort: ["Jan", "Feb", "Mar", "Apr", "Maj", "Jun", "Jul", "Avg", "Sep", "Okt", "Nov", "Dec"],
        today: "Danas",
        weekStart: 1,
        format: "dd.mm.yyyy"
    };
}(jQuery));
*/

$(function() {
    let dtp = $("#{{ 'dp-' . $id }}");
    let dtpHidden = $("#{{ $id }}");

    let config = $.extend({
        autoclose: true,
        todayHightlight: true,
        format: 'dd.mm.yyyy',
    }, @json($config ?? []));

    dtp.datepicker(config);

    //hack za setovanje datuma kada su razliciti formati prikaza i vrednosti koja se salje ka serveru
    dtp.on('change', function() {
        let momentObj = moment( dtp.val(), 'DD.MM.YYYY');

        // mora da se proveri ispravnost datuma i posebno da se setuje vrednost
        // kada je datum neispravan zato sto 'momentjs' vraca 'Invalid date' string
        if(momentObj.isValid()) { 
            dtpHidden.val(momentObj.format('YYYY-MM-DD'));
        }
        else { 
            dtpHidden.val('');
        }
    });

    // na 'hover' datum dugmeta izvrsi 'promenu stila tog dugmeta', na 'click' prikazi kalendar 
    dtp.parent().find('span')
    .hover(function() {
        $(this).toggleClass("newscms-hoverify");
        $(this).toggleClass("bg-custom");
    })
    .on('click', function(e) {
        e.preventDefault();
        dtp.datepicker('show');
        return false;
    });    

    // setuj 'disabled' dizajn 'datepicker'-a i 'disable'-uj ga
    //dtp.addClass('newscms-datepicker').prop('disabled', true)

});
</script>
@endpush