@extends('_layout.layout')

@section('head_title', __('Zaključan Resurs') . ' - ' . $lockedResource)

@push('head_links')
@endpush

@section('content')

    @include('_layout.partials.breadcrumbs', [
        'pageTitle' => __("Zaključan Resurs") . ' - ' . $lockedResource,
        'breadcrumbs' => [
            url('/') => __('Dashboard')
        ]
    ])

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-heading d-flex justify-content-between align-items-center">
                    <div class="card-heading-title">
                        <h3 class="card-title">@lang('Resurs zaključan')</h3>
                    </div>
                </div>
                <div class="card-body text-center">
                    <img src="{{asset('theme/assets/images/resource_lock.png')}}" alt="" style="max-width: 200px"
                         class="mb-2">

                    <h3>@lang('Resurs je zaključan od strane korisnika'):</h3>
                    <h4>{{$userName}}</h4>
                    @if($userEmail)
                        <p>{{$userEmail}}</p>
                    @endif
                    @if($userPhone)
                        <p>{{$userPhone}}</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection
@push('footer_scripts')
@endpush