@push('head_links')
<link href="/packages/fileinput/fileinput.css" rel="stylesheet">
<style>
    .fileinput {
        margin-bottom: 0px !important;
    }
    .fileinput-wrapper {
        display: table;
    }
    .fileinput.form-control {
        background-color: #e9ecef;
        color: '#dee2e6';
        width: 163px;
    }
    .fileinput.form-control:hover {
        background-color: #d9dcdf;
    }
    .fileinput.form-control > span{
        padding-left: 18px;
    }
    .fileinput-name {
        display: table-cell !important;
        vertical-align: middle;
        word-break: break-all;
        padding-bottom: 8px;
        padding-left: 10px;
    }
</style>
@endpush

@php
    // -- required --
    // $imageNameAttr

    // -- optional --
    // $imageLabel
    // $imageInputId
    // $showImageWrapperId
    // $imageInputButtonTitle
    // $isRequired

    $imageInputId = $imageInputId ?? 'ii_' . random_int(1, 10000);
    $showImageWrapperId = $showImageWrapperId ?? 'iw_' . random_int(10001, 10000000);
@endphp

<fieldset>
    <div class="form-group row">
        <label class="col-sm-3 control-label">{{ $imageLabel ?? __('Slika') }}@if(isset($required) && $required)<sup>*</sup>@endif</label>
        <div class="col-sm-9 d-none">
            <input 
                id="{{ $imageInputId }}"
                type="file" 
                class="form-control @errorClass($imageNameAttr, 'is-invalid')" 
                name="{{ $imageNameAttr }}" 
                placeholder="{{ $imageLabel ?? __('Slika') }}"
            >
            @if($errors->has($imageNameAttr)) {{-- Ne moze @formError() !!! --}}
                <div class="invalid-feedback" style="display: block;">
                    <strong>{{ $errors->first($imageNameAttr) }}</strong>
                </div>
            @endif
        </div>
    </div>
    <div class="form-group row">
        <label class="col-sm-3 control-label">@lang('Prikaz Slike')</label>
        <div class="col-sm-9" id="{{ $showImageWrapperId }}">
            <img src="{{ $entity->getImgSrcPath() }}" title="$entity->getImgTitle()" class="img-fluid @if(!$entity->image) d-none @endif"/>
        </div>
    </div>
</fieldset>

@push('footer_scripts')
<script src="/packages/fileinput/fileinput.min.js"></script>
<script>
$(function () {
    var blade = {
        imageNameAttr: "{{ $imageNameAttr }}",
        imageInputId: '#' + "{{ $imageInputId }}",
        imageInputButtonTitle: "{{ $imageInputButtonTitle ?? __('Izaberite sliku...') }}",
        showImageWrapperId: '#' + "{{ $showImageWrapperId }}"
    };

    // IMAGE INPUT
    $(blade.imageInputId).fileinput({
        title: blade.imageInputButtonTitle,
        clearButton: '',
        buttonClass: 'btn btn-default',
        complete: function(e) {
            // sprecava 'blink' originalnog 'file' elementa.
            $(blade.imageInputId).parents('div.d-none')//.parent().parent()
                                .removeClass('d-none');
        }
    });

    // IMAGE PREVIEW
    if(window.FileReader) {
        $(blade.imageInputId).on('change', function(e) {
            let files = e.target.files;
            let f = files[0];
            let reader = new FileReader();
            
            reader.onload = (function(inputFile) {
                    return function(e) {
                        $(blade.showImageWrapperId + " > img").attr('src', e.target.result)
                                                      .attr('title', inputFile.name)
                                                      .removeClass('d-none');
                    };
            })(f);
            
            reader.readAsDataURL(f);
        });
    }
    else {
        //TODO: posalji sliku na server preko ajaksa pozovi njen 'src' u 'img' elementu
        console.log('Pretrazivac ne podrzava "FileReader" API.');
    }
});
</script>
@endpush