<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Faktura</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }
        .invoice-container {
            width: 190mm; /* Manja širina da bi stalo na A4 */
            height: auto; /* Automatska visina prema sadržaju */
            padding: 5mm;
            margin: auto;
            box-sizing: border-box;
        }
        .header,
        .footer {
            display: flex;
            justify-content: space-between;
            flex-wrap: wrap; /* Omogućava prelamanje sadržaja */
        }
        .header div,
        .footer div {
            width: 48%; /* Smanjenje širine divova */
        }
        .header div p,
        .footer div p {
            margin: 2px 0;
            font-size: 10px; /* Manji font za bolju prilagodbu */
        }
        .title {
            text-align: center;
            font-size: 16px; /* Manji font za naslov */
            font-weight: bold;
            margin: 10px 0;
        }
        .table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
            font-size: 10px; /* Manji font za tabelu */
        }
        .table th, .table td {
            border: 1px solid #000;
            padding: 6px;
            text-align: left;
        }
        .table th:nth-child(2), .table td:nth-child(2) {
            width: 50%; /* Širina druge kolone */
        }
        .table th:nth-child(3), .table th:nth-child(4), .table th:nth-child(5),
        .table td:nth-child(3), .table td:nth-child(4), .table td:nth-child(5) {
            width: 15%; /* Širina kolona za iznose */
        }
        .total {
            margin-top: 10px;
            font-size: 10px; /* Manji font za ukupne iznose */
        }
        .total p {
            margin: 2px 0;
        }
        .bank-details {
            margin-top: 10px;
            font-size: 10px; /* Manji font za bankovne podatke */
        }
        .signature {
            margin-top: 200px;
            display: flex;
            justify-content: space-between;
            flex-wrap: wrap; /* Omogućava prelamanje sadržaja */
        }
        .signature div {
            width: 48%; /* Smanjena širina divova */
            text-align: center;
            font-size: 10px; /* Manji font za potpis */
        }
        .button-container {
            display: flex;
            justify-content: center; /* Centriranje dugmeta */
            margin-top: 20px;
        }
        .separator {
            border-top: 1px solid #000;
            margin-top: 20px;
        }
        .total input {
        font-weight: bold;
        }
        .total p {
            font-weight: bold;
        }
        .bank-details p {
            margin-bottom: 0;
            line-height: 1.5;
        }

        .table, .table th, .table td {
            border: 1px solid #000; /* Postavlja jedinstvenu granicu za sve elemente */
            border-collapse: collapse; /* Osigurava da se granice ne dupliraju */
        }
        
        @page {
            size: A4;
            margin: 10mm; /* Postavljanje margina za A4 papir */
        }
        input[type="text"] {
            border: none; /* Uklanja border */
        }
        textarea {
            border: none;
        }
        @media print {
            button {
                display: none; /* Sakriva sve dugmiće prilikom štampanja */
            }
            .no-print {
                display: none; /* Sakriva elemente sa klasom 'no-print' prilikom štampanja */
            }
        }

    </style>
</head>
<body>
    <div class="invoice-container">
        <div class="header">
            <div>
                <p>"VD-TRANS" Daniel Vasiljević s.p.</p>
                <p>Adresa: Gavrila Principa 1/4</p>
                <p>Grad: Ugljevik</p>
                <p>Mob.: +38766817447</p>
                <p>JIB: 4512499920003</p>
                <p>PDV: 512499920003</p>
            </div>
        </div>

        <p class="title">RAČUN Br: {{$invoice->id_invoice}}</p>

        <div class="header">
            <div style="margin-top: 40px;">
                <p>Datum utovara: <input type="text" id="loadingDate" value="10.01.2024." style="width: 120px; min-width: 100px; max-width: 300px;"></p>
                <p>Vozilo: <input style="width: 220px;" type="text" id="truckNumber" value="028-K-319 / J35-M-485"></p>
                <p>Datum računa: <input type="text" id="invoiceDate" value="13.01.2024."></p>
            </div>
            <div style="padding-left: 130px;">
                <p>{{$company->name}}</p>
                <p>{{$company->address}}</p>
                <p>JIB: {{$company->jib}}</p>
                <p>PDV: {{$company->jib}}</p>
            </div>
        </div>

        <table class="table" id="invoiceTable">
            <thead>
                <tr>
                    <th>Red br.</th>
                    <th>Naziv usluge</th>
                    <th>Iznos bez PDV-a</th>
                    <th><input style="width: 100%; font-weight: bold;" type="text" value="PDV 0%"></th>
                    <th>Iznos ukupno</th>
                    <th class="no-print">Akcija</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>1.</td>
                    <td><textarea style="width: 100%;">{{$invoice->text}}</textarea></td>
                    <td><input style="width: 100%;" type="text" value="{{$invoice->price}} {{$invoice->currency}}"></td>
                    <td><input style="width: 100%;" type="text" value="0,00"></td>
                    <td><input class="suma" style="width: 100%;" type="text" value="{{$invoice->price}} {{$invoice->currency}}"></td>
                    <td class="no-print"><button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">X</button></td> <!-- Dugme za uklanjanje reda -->
                </tr>
            </tbody>
        </table>

        <button type="button" class="btn btn-success no-print" onclick="addRow()">Dodaj Red</button>
        <button type="button" class="btn btn-info no-print" onclick="addNewTable()">Dodaj Istovar</button> <!-- Dugme za dodavanje nove tabele -->
        
        <div id="newTablesContainer"></div>

        <table class="table">
            <tbody>
                <tr>
                    <td style="text-align: center;">Ukupno za uplatu: <input type="text" value="{{$invoice->price}} {{$invoice->currency}}"></td>
                </tr>
            </tbody>
        </table>
        <br>
        <br>
        <div class="total" contenteditable="true">
            <p>Ukupan iznos bez PDV-a: <input type="text" value="{{$invoice->price}} {{$invoice->currency}}"></p>
            <p>
                <b>PDV <input style="width: 100px; white-space: pre;" type="text" value="0%"><input style="width: 90px; white-space: pre;" type="text" value="0.00 {{$invoice->currency}}"></b>
                <span>(po cl. 27 stav 1 tacka 2;cl. 26 stav 1 tacka 7;cl. 15 stav 2 tacka 2 ZPDV-a)</span>
            </p>
            <p>
                <b>Ukupan iznos sa PDV-om:</b> <input style="width: 86px;" type="text" value="{{$invoice->price}} {{$invoice->currency}}">
                <span><input style="width: 300px;" type="text" value="(Dvijehiljadecetrdesetdevet KM i 80/100) "></span>
            </p>
        </div>

        <br>

        <div class="bank-details">
            <b>UPLATU IZVRŠITI NA RAČUN:</b>
            <p>RAIFFEISEN BANK DD BOSNA I HERCEGOVINA</p>
            <p>ADRESA: ZMAJA OD BOSNE BB, SARAJEVO BIH</p>
            <p>SWIFT CODE: RZBABA2S</p>
            <p>IBAN CODE: BA391610000286090065</p>
            <br>
            <b>ROK PLAĆANJA: <input type="text" value="60 DANA"></td></b>
        </div>

        <div class="signature">
            <div>
                <p>Račun primio:</p>
                <p>____________________</p>
            </div>
            <div>
                <p>Fakturirao:</p>
                <p>"VD-TRANS" Daniel Vasiljević s.p.</p>
                <p>M.P.</p>
            </div>
        </div>
    </div>

   
    

    <div class="separator"></div>

    <div class="button-container no-print">
        <button type="button" class="btn btn-primary" onclick="saveAsPDF()">Snimi kao PDF</button>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.9.2/html2pdf.bundle.min.js"></script>
    <script>
        function addRow() {
            var table = document.getElementById('invoiceTable').getElementsByTagName('tbody')[0];
            var rowCount = table.rows.length;
            var newRow = table.insertRow(rowCount);

            newRow.innerHTML = `
                <td style="">${rowCount + 1}.</td>
                <td style="width: 50%;"><textarea style="width: 100%;;"></textarea></td>
                <td style="width: 15%;"><input type="text" style="width: 100%;"></td>
                <td style="width: 15%;"><input type="text" style="width: 100%;"></td>
                <td style="width: 15%;"><input type="text" style="width: 100%;"></td>
                <td class="no-print" style=""><button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">X</button></td>
            `;
        }

        function removeRow(button) {
            var row = button.closest('tr');
            row.parentNode.removeChild(row);
            updateRowNumbers();
        }

        function updateRowNumbers() {
            var table = document.getElementById('invoiceTable').getElementsByTagName('tbody')[0];
            var rows = table.getElementsByTagName('tr');
            for (var i = 0; i < rows.length; i++) {
                rows[i].cells[0].textContent = (i + 1) + '.';
            }
        }

        function addNewTable() {
            var newTable = document.createElement('table');
            newTable.classList.add('table');
            newTable.style.width = '100%';
            newTable.style.borderCollapse = 'collapse';
            newTable.innerHTML = `
                <tbody>
                    <tr>
                        <td style="border: 1px solid #000; padding: 6px;">Broj istovara</td>
                        <td style="border: 1px solid #000; padding: 6px;"><input style="width: 300px;" type="text" value="1. Europa-Odzaci"></td>
                        <td style="border: 1px solid #000; padding: 6px;"><input type="text" value="40 KM"></td>
                        <td rowspan="2" style="border: 1px solid #000; padding: 6px; vertical-align: middle;"><input type="text" value="80 KM"></td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #000; padding: 6px;"></td>
                        <td style="border: 1px solid #000; padding: 6px;"><input style="width: 300px;" type="text" value="2. Europa-Odzaci"></td>
                        <td style="border: 1px solid #000; padding: 6px;"><input type="text" value="40 KM"></td>
                    </tr>
                </tbody>
            `;
            document.getElementById('newTablesContainer').appendChild(newTable);
        }

        function saveAsPDF() {
            var elementsToHide = document.querySelectorAll('.no-print');
            elementsToHide.forEach(function(element) {
                element.style.display = 'none';
            });

            var element = document.querySelector('.invoice-container');
            html2pdf().from(element).save('{{$invoice->id_invoice}}.pdf').then(function() {
                elementsToHide.forEach(function(element) {
                    element.style.display = '';
                });
            });
        }
    </script>
</body>
</html>
</body>
</html>