@push('head_links')
<link href="{{asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.css')}}" rel="stylesheet" />
@endpush

<form id="entity-form" class="form-horizontal" method="post" action="" 
      enctype="multipart/form-data" autocomplete="off">
    <div class="row">
        <div class="col-lg-7 align-self-center">
            @csrf
            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('Proizvodjač')<sup>*</sup></label>
                <div class="col-sm-9">
                    <input 
                        type="text" 
                        class="form-control @errorClass('producer', 'is-invalid')" 
                        name="producer" 
                        placeholder="@lang('Proizvodjač')" 
                        value="{{old('producer', $entity->producer)}}"
                    >
                    @formError(['field' => 'producer'])
                    
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('Naziv vozila')<sup>*</sup></label>
                <div class="col-sm-9">
                    <input 
                        type="text" 
                        class="form-control @errorClass('name', 'is-invalid')" 
                        name="name" 
                        placeholder="@lang('Naziv vozila')" 
                        value="{{old('name', $entity->name)}}"
                    >
                    @formError(['field' => 'name'])
                    
                </div>
            </div>
            
            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('Broj saobraćajne')</label>
                <div class="col-sm-9 input-group">
                    <input 
                        type="text" 
                        class="form-control @errorClass('phone', 'is-invalid')" 
                        name="traffic_number" 
                        placeholder="@lang('Broj saobraćajne')" 
                        value="{{old('traffic_number', $entity->traffic_number)}}"
                    >
                    <span class="input-group-addon bootstrap-touchspin-postfix input-group-append">
                        <span class="input-group-text">
                            <i class="fa fa-credit-card"></i>
                        </span>
                    </span>
                    @formError(['field' => 'traffic_number'])
                    
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('Tablice')</label>
                <div class="col-sm-9 input-group">
                    <input 
                        type="text" 
                        class="form-control @errorClass('number_of_plates', 'is-invalid')" 
                        name="number_of_plates" 
                        placeholder="@lang('Tablice')" 
                        value="{{old('number_of_plates', $entity->number_of_plates)}}"
                    >
                    <span class="input-group-addon bootstrap-touchspin-postfix input-group-append">
                        <span class="input-group-text">
                            <i class="fa fa-solid fa-truck"></i>
                        </span>
                    </span>
                    @formError(['field' => 'number_of_plates'])
                    
                </div>
            </div>
            
        </div>
        <div class="col-4 offset-1">
            {{-- slika --}}
        </div>
    </div>
    <hr>
    <div class="form-group row">
        <div class="col-sm-9">
            <button type="submit" class="btn btn-success waves-effect waves-light">
                <i class="fa fa-save"></i>
                @lang('Sačuvaj')
            </button>
        </div>
    </div>
</form>

@push('footer_scripts')
<script src="{{asset('/theme/plugins/bootstrap-filestyle/js/bootstrap-filestyle.min.js')}}"></script>
<script src="{{asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.js')}}"></script>
<script>
$(function() {
    
    $(document).ready(function() {
    $('#entity-form').validate({
        rules: {
            producer: {
                required: true
            },
            name: {
                required: true
            },
            traffic_number: {
                required: true,
                maxlength: 20
            },
            number_of_plates: {
                required: true,
                maxlength: 10
            }
        },
        messages: {
            
        },
    });
});

});
</script>
@endpush