<?php $__env->startSection('head_title', __('Fakture') . ' - ' . __('Fakture')); ?>

<?php $__env->startPush('head_links'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<?php echo $__env->make('_layout.partials.breadcrumbs', [
    'pageTitle' => __("Fakture"),
    'breadcrumbs' => [
        route('truck.invoices') => __('Fakture')
    ]
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style>
    .date-highlight {
        padding: 5px;
        border-radius: 5px;
        display: inline-block;
    }
    .date-red {
        background-color: red;
        color: white;
    }
    .date-yellow {
        background-color: yellow;
        color: black;
    }
    .date-green {
        background-color: green;
        color: white;
    }
</style>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-heading d-flex justify-content-between">
                <div class="card-heading-title">
                    <h3 class="card-title"><?php echo app('translator')->get('Izvestaj sa filterima'); ?></h3>
                </div>
            </div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-2">
                        <label for="date_start"><?php echo app('translator')->get('Datum od'); ?></label>
                        <input type="date" id="date_start" class="form-control">
                    </div>
                    <div class="col-md-2">
                        <label for="date_end"><?php echo app('translator')->get('Datum do'); ?></label>
                        <input type="date" id="date_end" class="form-control">
                    </div>
                    <div class="col-md-2">
                        <label for="driver"><?php echo app('translator')->get('Izaberi vozača'); ?></label>
                        <select id="driver" class="form-control">
                            <option value=""><?php echo app('translator')->get('Svi vozači'); ?></option>
                            <?php $__currentLoopData = $drivers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $driver): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($driver->id); ?>"><?php echo e($driver->first_name); ?> <?php echo e($driver->last_name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label for="statusFilter"><?php echo app('translator')->get('Filter po statusu:'); ?></label>
                        <select id="statusFilter" class="form-control">
                            <option value=""><?php echo app('translator')->get('Svi'); ?></option>
                            <option value="1"><?php echo app('translator')->get('Plaćeno'); ?></option>
                            <option value="0"><?php echo app('translator')->get('Neplaćeno'); ?></option>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label for="company"><?php echo app('translator')->get('Izaberi firmu'); ?></label>
                        <select id="company" class="form-control">
                            <option value=""><?php echo app('translator')->get('Sve firme'); ?></option>
                            <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($company->id); ?>"><?php echo e($company->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped" id="entity-list-table" class="display" style="width:100%">
                        <thead>
                            <tr>
                                <th class=""><?php echo app('translator')->get('Broj fakture'); ?></th>
                                <th class=""><?php echo app('translator')->get('Firma'); ?></th>
                                <th class=""><?php echo app('translator')->get('Datum kreiranja'); ?></th>
                                <th class=""><?php echo app('translator')->get('Vazač'); ?></th>
                                <th class=""><?php echo app('translator')->get('Kamion'); ?></th>
                                <th class=""><?php echo app('translator')->get('Rok placanja'); ?></th>
                                <th class="disabled-sorting text-right"><?php echo app('translator')->get('Status'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
    
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('footer_scripts'); ?>
<script>
$(function() {

    var dateFormat = 'dd/mm/yyyy';

    $('#date_start, #date_end').datepicker({
        format: dateFormat,
        autoclose: true
    });
    
    var blade = {
        datatablesAjaxUrl: "<?= route('truck.reports_datatable'); ?>",
    };

    // DATATABLES
    var table = $('#entity-list-table').DataTable({
        "autoWidth": true,
        "processing": true,
        "serverSide": true,
        "searchable": false,
        "ajax": {
            url: blade.datatablesAjaxUrl,
            type: "post",
            data: function(d) {
                d.date_start = $('#date_start').val();
                d.date_end = $('#date_end').val();
                d.driver = $('#driver').val();
                d.company = $('#company').val();
            }
        },
        "columns": [
            {"data": "id_invoice", orderable: false, "className": ""},
            {"data": "company", orderable: false, "className": ""},
            {"data": "date_start", orderable: false, searchable: false, "className": ""},
            {"data": "driver", orderable: false, "className": ""},
            {"data": "truck", orderable: false, "className": ""},
            {"data": "date_end", orderable: false, searchable: false, "className": ""},
            {"data": "actions", orderable: false, searchable: false, "className": "text-right"}
        ],
        "order": [[0, "asc"]],
        "rowCallback": function(row, data, index) {
            var today = moment();
            var dateEnd = moment(data.date_end, 'DD-MM-YYYY'); // Adjust the date format to match your data

            // Reset any previous highlighting
            $('td:eq(5)', row).removeClass('date-red date-yellow date-green');

            // Add the appropriate class based on the date condition
            if (data.status == 1) {
                $('td:eq(5)', row).html('<span class="date-highlight date-green">' + data.date_end + '</span>');
            } else if (today.isSameOrAfter(dateEnd, 'day')) {
                $('td:eq(5)', row).html('<span class="date-highlight date-red">' + data.date_end + '</span>');
            } else if (today.isSameOrAfter(dateEnd.subtract(7, 'days'), 'day')) {
                $('td:eq(5)', row).html('<span class="date-highlight date-yellow">' + data.date_end + '</span>');
            } else {
                $('td:eq(5)', row).html(data.date_end);
            }
        }
    });

    $('#date_start, #date_end, #driver, #company').change(function() {
        table.ajax.reload();
    });

});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('_layout.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/cms/resources/views/truck/reports/index.blade.php ENDPATH**/ ?>