<div class="row">
    <div class="col-12 all-images-actions mb-3 px-3 py-3">
        <button class="btn btn-sm btn-secondary mr-3 select select-all-images">
            <i class="fa fa-search"></i>
            <span class="ml-1"><?php echo app('translator')->get('Izaberi sve slike'); ?></span>
        </button>
        <button class="btn btn-sm btn-secondary mr-3 delete remove-all-images">
            <i class="fa fa-trash"></i>
            <span class="ml-1"><?php echo app('translator')->get('Obriši sve slike'); ?></span>
        </button>
    </div>
    <div class="col-12 inputs-each">
        <div class="accordion" id="imageSizeList">
            <?php $__currentLoopData = configMediaThumbs()->where('admin_crop', true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $tabName = $img['name'] . ' (' . $img['width'] . 'x' . $img['height'] .')';   
                    $tabId = str_replace(' ', '', $img['name']);
                    $contentId = $tabId . 'Content';
                    $inputName = 'image_' . $img['id'];
                    $placeholderSizes = $img['width'] . 'x' . ($img['height'] == 'auto' ? '300' : $img['height']);
                    $placeholderName = $img['width'] . 'x' . $img['height'];
                    $entValue =  old($inputName, $entity->{$inputName})  ?: '';
                    $entSrc = old($inputName, $entity->{$inputName}) ?: 'https://via.placeholder.com/' . $placeholderSizes .'&text=('. $placeholderName . ')';
                ?>
                <div class="card mb-0 img-each">
                    <div class="card-header p-0" id="<?php echo e($tabId); ?>">
                        <h4 class="p-2 cursor-pointer" data-toggle="collapse"
                            data-target="#<?php echo e($contentId); ?>"
                            aria-expanded="false"
                            aria-controls="<?php echo e($contentId); ?>"
                        >
                            <?php echo e($tabName); ?>

                        </h4>
                    </div>
                    <div id="<?php echo e($contentId); ?>" class="collapse <?php echo e($loop->first ? 'show' : ''); ?>"
                         aria-labelledby="<?php echo e($tabId); ?>"
                         data-parent="#imageSizeList">
                        <input type="hidden" name="<?php echo e($inputName); ?>" value="<?php echo e($entValue); ?>" id="<?php echo e($inputName); ?>">
                        <div class="card-body" style="">
                            <img style="max-width:100%;"
                                 alt="thumb"
                                 data-photo-thumb-type="<?php echo e($img['id']); ?>"
                                 data-photo-placeholder="https://via.placeholder.com/<?php echo e($placeholderSizes); ?>&text=(<?php echo e($placeholderName); ?>)"
                                 src="<?php echo e($entSrc); ?>">

                        </div>
                        <div class="card-footer image-actions">
                            <button class="btn btn-sm btn-secondary mr-3 select choose-photo">
                                <i class="fa fa-search"></i>
                                <span class="ml-1"><?php echo app('translator')->get('Izaberi sliku'); ?></span>
                            </button>
                            <button class="btn btn-sm btn-secondary mr-3 delete remove-one-photo">
                                <i class="fa fa-trash"></i>
                                <span class="ml-1"><?php echo app('translator')->get('Obriši sliku'); ?></span>
                            </button>
                            <button class="btn btn-sm btn-secondary mr-3 edit edit-photo">
                                <i class="fa fa-edit"></i>
                                <span class="ml-1"><?php echo app('translator')->get('Izmeni sliku'); ?></span>
                            </button>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <div class="imageless-inputs">
            <?php $__currentLoopData = configMediaThumbs()->where('admin_crop', false); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $inputName =  'image_' . $img['id'] ;
                    $entValue = $entity->{$inputName} ?: '';
                ?>
                <input type="hidden" name="<?php echo e($inputName); ?>" value="<?php echo e(old($inputName, $entValue)); ?>" id="<?php echo e($inputName); ?>">
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>

<?php $__env->startPush('footer_scripts'); ?>
    <script>
        //************************************************************************************************************//

        //************ INSERT ONE/ALL FUNCTIONS****************//

        function insertAllImages(photoObj) {
            let dataSources = photoObj.photoAllImgSources;
            $.each(dataSources, function (key, item) {
                $(`img[data-photo-thumb-type="${key}"]`).attr('src', item);
                $(`input[name="image_${key}"]`).val(item);
            });
        }

        function insertOneImage(photoObj, masterParent) {
            let imgTag = masterParent.find('img');
            let imageSize = imgTag.data('photo-thumb-type');
            let dataSources = photoObj.photoAllImgSources;
            imgTag.attr('src', dataSources[imageSize]);
            updateInput(imageSize, dataSources);
        }

        //************ REMOVE ONE/ALL FUNCTIONS****************//

        function removeAllImages() {

            $.each($('div.img-each'), function () {
                let imgTag = $(this).find('img');
                let imageSize = imgTag.data('photo-thumb-type');
                let imagePlaceHolder = imgTag.data('photo-placeholder');
                imgTag.attr('src', imagePlaceHolder);
                updateInput(imageSize, "");
            });
            $.each($('div.imageless-inputs input'), function () {
                $(this).val("");
            });
        }

        function removeOneImage(masterParent) {
            let imgTag = masterParent.find('img');
            let imageSize = imgTag.data('photo-thumb-type');
            let imagePlaceHolder = imgTag.data('photo-placeholder');
            imgTag.attr('src', imagePlaceHolder);
            updateInput(imageSize, "");
        }

        //************ INPUTS HELPER FUNCTIONS****************//
        /**
         * FINDING AND UPDATING INPUTS OF IMG TYPE
         * USE: UpdatePair(imageSize, src)
         **/
        function updateInput(imageSize, photoObj) {
            console.log(typeof photoObj);
            if (typeof photoObj == 'string') {
                $('.article-images div.inputs-each').find(`input[name=image_${imageSize}]`).val(photoObj);
                updatePair(imageSize, photoObj);
            }

            $('.article-images div.inputs-each').find(`input[name=image_${imageSize}]`).val(photoObj[imageSize]);
            updatePair(imageSize, photoObj);
        }

        /**
         * FINDING ALL PAIRS OF IMG TYPE AND UPDATING PAIR INPUTS
         ** USE: findPair(imageSize, pairsConfig)
         **/
        function updatePair(imageSize, photoObj) {
            let pairsConfig = JSON.parse(`<?php echo json_encode(configMediaThumbs()); ?>`);
            let pairs = findPair(imageSize, pairsConfig);
            let pairsTypes = new Array();
            $.each(pairs, function (key, item) {
                pairsTypes.push(this.id);
            });
            $.each(pairsTypes, function (key, item) {
                if (typeof photoObj == 'string') {
                    $('.article-images div.inputs-each').find(`input[name=image_${this}]`).val(photoObj);
                }
                $('.article-images div.inputs-each').find(`input[name=image_${this}]`).val(photoObj[item]);
            });
        }

        /**
         * FINDING ALL PAIRS OF IMG TYPE
         **/
        function findPair(imageSize, pairsConfig) {
            return pairsConfig.filter(
                function (pairsConfig) {
                    return pairsConfig.source == imageSize
                }
            );
        }

        //************************************************************************************************************//

        $(document).ready(function () {
            /**
             * NEW INSTANCE OF MEDIA LIBRARY
             **/
            let mediaLibrary = new MediaLibrary();

            /**
             * EVENT LISTENERS - BUTTONS
             **/
            $('.article-images button').on('click', function (e) {
                e.preventDefault();
                e.stopPropagation();

                //************ SELECT ALL BUTTON ****************//
                if ($(this).hasClass('select-all-images')) {
                    mediaLibrary.openSelectPhoto(function (photoObj) {
                        insertAllImages(photoObj);
                        mediaLibrary.modalHide();
                    });
                }

                //************ REMOVE ALL BUTTON ****************//
                if ($(this).hasClass('remove-all-images')) {
                    removeAllImages();
                }

                //************ SELECT PHOTO BUTTON ****************//
                if ($(this).hasClass('choose-photo')) {
                    let masterParent = $(this).parents('div.img-each');
                    mediaLibrary.openSelectPhoto(function (photoObj) {
                        insertOneImage(photoObj, masterParent);
                        mediaLibrary.modalHide();
                    });
                }

                //************ EDIT ONE BUTTON ****************//
                if ($(this).hasClass('edit-photo')) {
                    let masterParent = $(this).parents('div.img-each');
                    let imgTag = masterParent.find('img');
                    let imageSize = imgTag.data('photo-thumb-type');
                    let photoId = imgTag.attr('src').split('/').pop().split('_')[0];
                    if (!isNaN(photoId)) {
                        let selection = {
                            photoId: parseInt(photoId),
                            thumbSizeId: imageSize,
                            position: 'center',
                            signature: ' '
                        };
                        mediaLibrary.openSelectPhoto(function (photoObj) {
                            insertOneImage(photoObj, masterParent);
                            mediaLibrary.modalHide();
                        }, selection);
                    }
                }

                //************ REMOVE ONE BUTTON ****************//
                if ($(this).hasClass('remove-one-photo')) {
                    let masterParent = $(this).parents('div.img-each');
                    removeOneImage(masterParent);
                }
            });

        });
        //************************************************************************************************************//

    </script>
<?php $__env->stopPush(); ?><?php /**PATH /opt/cms/resources/views/articles/partials/form/images.blade.php ENDPATH**/ ?>