<?php echo $__env->make('truck.reports.partials.summary', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<div class="col-lg-12 col-sm-12">
    <table class="table table-striped table-bordered table-responsive-md mt-4">
        <thead>
        <tr>
            <th colspan="7" class="text-center bg-light">
                <?php echo app('translator')->get('Vesti koje je kreirao admin korisnik'); ?>
            </th>
        </tr>
        <tr>
            <th scope="col"><?php echo app('translator')->get('Vreme'); ?></th>
            <th scope="col"><?php echo app('translator')->get('Kategorija'); ?></th>
            <th scope="col" class="text-center" style="min-width: 400px;"><?php echo app('translator')->get('Naslov vesti'); ?></th>
            <th scope="col"><?php echo app('translator')->get('Pregleda'); ?></th>
            <th scope="col"><?php echo app('translator')->get('Komentara'); ?></th>
        </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $entities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $entity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <th scope="row"><?php echo e($entity->time_created->format("d.m.Y H:i")); ?></th>
                <td>
                    <?php if($entity->category): ?>
                        <span class="badge badge-pill badge-warning"><?php echo e(optional($entity->category)->name); ?>/<?php echo e(optional($entity->subcategory)->name); ?></span>
                        <br>
                    <?php endif; ?>
                    
                    <span class="badge badge-pill badge-info"><a target="_blank" href="<?php echo e($entity->getMainUrl()); ?>"><?php echo app('translator')->get('link do vesti'); ?></a></span>
                    <br>
                </td>
                <td><?php echo e($entity->heading); ?></td>

                <td><?php echo e($entity->views); ?></td>
                <td><?php echo e($entity->total_comments_count); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>

<?php /**PATH /opt/cms/resources/views/truck/reports/tables/admin_user_statistics_table.blade.php ENDPATH**/ ?>