<?php $__env->startSection('head_title', __('Vozači') . ' - ' . __('Vozači')); ?>

<?php $__env->startPush('head_links'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<?php echo $__env->make('_layout.partials.breadcrumbs', [
    'pageTitle' => __("Vozači"),
    'breadcrumbs' => [
        route('truck.drivers') => __('Vozači')
    ]
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-heading d-flex justify-content-between">
                <div class="card-heading-title">
                    <h3 class="card-title"><?php echo app('translator')->get('Lista Vozača'); ?></h3>
                </div>
                <div class="card-heading-actions">
                    <a href="<?php echo e(route('truck.drivers_create')); ?>" class="btn btn-primary">
                        <i class="fa fa-plus"></i>
                        <?php echo app('translator')->get('Dodaj'); ?>
                    </a>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped" id="entity-list-table">
                        <thead>
                            <tr>
                                <th class=""><?php echo app('translator')->get('Slika'); ?></th>
                                <th class=""><?php echo app('translator')->get('Ime'); ?></th>
                                <th class=""><?php echo app('translator')->get('Prezime'); ?></th>
                                <th class=""><?php echo app('translator')->get('Email'); ?></th>
                                <th class=""><?php echo app('translator')->get('JMBG'); ?></th>
                                <th class=""><?php echo app('translator')->get('Telefon'); ?></th>
                                <th class="disabled-sorting text-right"><?php echo app('translator')->get('Opcije'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
    
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('footer_scripts'); ?>
<script>
$(function() {
    
    var blade = {
        datatablesAjaxUrl:"<?= route('truck.drivers_datatable'); ?>"
    };
    
    // DATATABLES
    $('#entity-list-table').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            url: blade.datatablesAjaxUrl,
            type: "post",
        },
        "columns": [
            {"data": "image", orderable: false, searchable: false, "className": ""},
            {"data": "first_name", "className": ""},
            {"data": "last_name", "className": ""},
            {"data": "email", "className": ""},
            {"data": "jmbg", "className": ""},
            {"data": "phone", "className": ""},
            {"data": "actions", orderable: false, searchable: false, "className": "text-right"}
        ],
        "order": [[0, "asc"]]
    });
    
    
    // DELETE MODAL
    let options = {
        "title": "Obriši",
        "liveSelector": '[data-action="delete"]'
    };
    
    $('#entity-list-table').questionPop(options).on('success.qp', function() {
        $('#entity-list-table').DataTable().draw('page');
    });

});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('_layout.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/cms/resources/views/truck/drivers/index.blade.php ENDPATH**/ ?>