<div class="card">
    <div class="card-heading d-flex justify-content-between align-items-center">
        <div class="card-heading-title">
            <h3 class="card-title"><?php echo app('translator')->get('Postojeće vesti'); ?></h3>
            <p class="card-sub-title text-muted"><?php echo app('translator')->get('Filtrirajte vesti'); ?></p>
        </div>
        <div class="card-heading-actions">
        </div>
    </div>
    <div class="card-body pt-1">
        <form id="entities-list-form">
            <div class="row article-filters">
                <div class="col-sm-6">
                    <div class="form-group" style="display:none;">
                        <label class="control-label"><?php echo app('translator')->get('Sajt'); ?></label>
                        <div class="">
                            <select name="website" class="form-control article-website">
                                <option value="0"><?php echo app('translator')->get('Izaberite Sajt'); ?></option>s
                                <?php $__currentLoopData = $websites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $website): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($website->id); ?>"><?php echo e($website->title); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6"></div>
                <div class="col-sm-4">
                    <div class="form-group">
                        <label class="control-label"><?php echo app('translator')->get('Od'); ?></label>
                        <div class="">
                            <input
                            id="datepicker"
                            type="text"
                            class="form-control <?= $errors->has("edition_from") ? 'is-invalid' : ""; ?>"
                            name="edition_from"
                            placeholder="<?php echo app('translator')->get('Datum'); ?>"
                            value =""
                            data-index="1"
                        >
                        </div>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        <label class="control-label"><?php echo app('translator')->get('Do'); ?></label>
                        <div class="">
                            <input
                                id="datepicker_two"
                                type="text"
                                class="form-control <?= $errors->has("edition_two") ? 'is-invalid' : ""; ?>"
                                name="edition_two"
                                placeholder="<?php echo app('translator')->get('Datum'); ?>"
                                value =""
                                data-index="2"
                            >
                        </div>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        <label class="control-label"><?php echo app('translator')->get('Prikaži sve'); ?></label>
                        <div class="">
                            <input type="checkbox" name="all_articles" class="all_articles">
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <label class="control-label"><?php echo app('translator')->get('Status'); ?></label>
                    <div class="">
                        <select name="approval-status" class="form-control article-approval-status">
                            <option value="0"><?php echo app('translator')->get('Sve vesti'); ?></option>
                            <option value="1"><?php echo app('translator')->get('Odobrene'); ?></option>
                            <option value="2"><?php echo app('translator')->get('Neodobrene'); ?></option>
                        </select>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="control-label"><?php echo app('translator')->get('Kategorija'); ?></label>
                        <div class="">
                            <select name="main-category" class="form-control article-category" data-website-id="0">

                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="control-label"><?php echo app('translator')->get('Podkategorija'); ?></label>
                        <div class="">
                            <select name="main-subcategory" class="form-control article-subcategory" data-website-id="0">

                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <label class="control-label"><?php echo app('translator')->get('Tip vesti'); ?></label>
                        <div class="">
                            <select name="publication_reason" class="form-control article-publication-reasons">
                                <option value="0"><?php echo app('translator')->get('Sve vesti'); ?></option>
                                <option value="editorial"><?php echo app('translator')->get('Obicna vest'); ?></option>
                                <option value="sponsored"><?php echo app('translator')->get('Sponzorisana vest'); ?></option>
                            </select>
                        </div>
                </div>
                <div class="col-sm-6">
                    <label class="control-label"><?php echo app('translator')->get('Trajenje vesti'); ?></label>
                        <div class="">
                            <select name="lifetime" class="form-control article-lifetime">
                                <option value="0"><?php echo app('translator')->get('Sve vesti'); ?></option>
                                <option value="evergreen"><?php echo app('translator')->get('Trajna vest'); ?></option>
                                <option value="seasonal"><?php echo app('translator')->get('Sezonska vest'); ?></option>
                                <option value="time_limited"><?php echo app('translator')->get('Ogranicena vest'); ?></option>
                            </select>
                        </div>
                </div>
            </div>
        </form>
        <table id="entities-table" class="table table-striped">
            <thead>
                <tr>
                    <th class="text-left" data-orderable="false"><?php echo app('translator')->get('Vest'); ?></th>
                </tr>
            </thead>
            <tbody>

            </tbody>
        </table>
    </div>
</div>

<?php $__env->startPush('footer_scripts'); ?>
<script>
    let allArticles = 0;
    /*Uzimamo sutrasnji dan*/
    let tomorrow = <?php echo json_encode(date('Y-m-d',strtotime(' +1 day'))); ?>;

    if($('.all_articles').is(':checked') ){
        allArticles = 1;
    }

    if(allArticles == 1) {
        $("#datepicker_two").prop( "disabled", true );
        $("#datepicker").prop( "disabled", true );
    }else {
        $("#datepicker_two").prop( "disabled", false );
        $("#datepicker").prop( "disabled", false );
    }

    $('.all_articles').on('click',function() {
        if($('.all_articles').is(':checked') ){
            allArticles = 1;
            $("#datepicker_two").prop( "disabled", true );
            $("#datepicker").prop( "disabled", true );
        }else {
            allArticles = 0;
            $("#datepicker_two").prop( "disabled", false );
            $("#datepicker").prop( "disabled", false );
        }
    })

    $('#entities-list-form [name="edition_from"]').datepicker({
        format:'yyyy-mm-dd'
    });
    $("#datepicker").datepicker("setDate", new Date());

    $('#entities-list-form [name="edition_two"]').datepicker({
        format:'yyyy-mm-dd'
    });
    $("#datepicker_two").datepicker("setDate", tomorrow);

    $('.article-filters select').select2({
        minimumResultsForSearch: -1
    });

    var updateSelect = function (element, jsonData, category = false, destroyElement = false) {

        let siteId = element.data('website-id');
        let data = jsonData.filter(function (n) {
            if (category) {
                return n.site_id == siteId && n.parent_id == category;
            } else {
                return n.site_id == siteId;
            }
        }).map(function (obj) {
            return {
                'id': obj.id,
                'text': obj.text
            }
        });

        if (destroyElement) {
            destroyElement.select2('destroy').empty();
            destroyElement.select2({
                minimumResultsForSearch: -1,
                data: data
            });
        } else {
            element.select2({
                minimumResultsForSearch: -1,
                data: data
            });
    }
    };

    var categories = JSON.parse('<?php echo $filterCategories; ?>');
    var subCategories = JSON.parse('<?php echo $filterSubCategories; ?>');

    $('.article-filters select').each(function (key, item) {
        let val = $('.article-filters select.article-website').val();
        if ($(this).hasClass('article-category')) {
            $(this).data('website-id', val);
            updateSelect($(this), categories);

        } else if ($(this).hasClass('article-subcategory')) {
            let siteId = $(this).data('website-id');
            let selectedCategory = $('.article-filters select.article-category[data-website-id=' + siteId + ']').val();
            $(this).data('website-id', val);
            updateSelect($(this), subCategories, selectedCategory);

        }
    });

    $('.article-filters select.article-category').on('change', function (e) {
        let siteId = $(this).data('website-id');
        let category = $(this).val();
        console.log($(this));
        updateSelect($(this), subCategories, category, $('.article-filters select.article-subcategory[data-website-id=' + siteId + ']'));
    });
////////////////////////////////////////////////////////////////////////////////////////////////////


    $('.article-filters select.article-website').on('change', function (e) {

        if ($('.article-filters select.article-website').val() != 0) {
            $('.article-filters select.article-category').attr('name', 'category');
            $('.article-filters select.article-subcategory').attr('name', 'subcategory');
        } else {
            $('.article-filters select.article-category').attr('name', 'main-category');
            $('.article-filters select.article-subcategory').attr('name', 'main-subcategory');
        }

        let val = $(this).val();

        $('.article-filters select.article-category').attr('data-website-id', val);
        $('.article-filters select.article-subcategory').attr('data-website-id', val);

        $('.article-filters select').each(function (key, item) {
            if ($(this).hasClass('article-category')) {
                $(this).data('website-id', val);
                let cat = false;
                let siteId = $('.article-filters select.article-website').val();
                updateSelect($(this), categories, cat, $('.article-filters select.article-category[data-website-id=' + siteId + ']'));

            } else if ($(this).hasClass('article-subcategory')) {
                let siteId = $('.article-filters select.article-website').val();
                let selectedCategory = $('.article-filters select.article-category[data-website-id=' + siteId + ']').val();
                $(this).data('website-id', val)
                let destroyElement = true;
                updateSelect($(this), subCategories, selectedCategory, $('.article-filters select.article-subcategory[data-website-id=' + siteId + ']'));

            }
        });
    });

    if ($('.article-filters select.article-website').val() != 0) {
        $('.article-filters select.article-category').attr('name', 'category');
        $('.article-filters select.article-subcategory').attr('name', 'subcategory');
    } else {
        $('.article-filters select.article-category').attr('name', 'main-category');
        $('.article-filters select.article-subcategory').attr('name', 'main-subcategory');
    }


    let entityDatatable = $('#entities-table').DataTable({
        "processing": true,
        "serverSide": true,
        "searching": false,
        "ajax": {
            url: "<?= route('comments.datatable'); ?>",
            type: "POST",
            data: function (dtData) {
                dtData['website'] = $('div.article-filters select[name="website"]').val();
                dtData['edition_from'] = $('div.article-filters input[name="edition_from"]').val();
                dtData['edition_two'] = $('div.article-filters input[name="edition_two"]').val();
                dtData['approval_status'] = $('div.article-filters select[name="approval-status"]').val();
                dtData['main_category'] = $('div.article-filters select[name="main-category"]').val();
                dtData['main_subcategory'] = $('div.article-filters select[name="main-subcategory"]').val();
                dtData['category'] = $('div.article-filters select[name="category"]').val();
                dtData['subcategory'] = $('div.article-filters select[name="subcategory"]').val();
                dtData['publication_reason'] = $('div.article-filters select[name="publication_reason"]').val();
                dtData['lifetime'] = $('div.article-filters select[name="lifetime"]').val();
                dtData['all_articles'] = allArticles;
            }
        },
        "aaSorting": [],
        'columns': [
            {"data": "item", className: "text-left", "searchebale": false, "orderable": false},
        ]
    });

    $('#entities-list-form [name]').on('change', function (e) {
        $('#entities-list-form').trigger('submit');
    });

    $('#entities-list-form').on('submit', function (e) {
        e.preventDefault();
        entityDatatable.ajax.reload(null, false);
    });

    $('#entities-table').questionPop({
        "liveSelector": '[data-action="delete"]'
    }).on('success.qp', function () {
        $('#entities-table').DataTable().draw('page');

    });
</script>
<?php $__env->stopPush(); ?><?php /**PATH /opt/cms/resources/views/comments/partials/list.blade.php ENDPATH**/ ?>