<!-- begin:system-message rendering script-->
<script type="text/javascript">
    function showSystemMessage(text, type) {
        type = type ? type : 'success';

        var options = {
            text: text,
            position: 'top-right',
            icon: type
        };

        switch (type) {
            case 'success':
                $.extend(options, {
                    heading: '<?php echo app('translator')->get("OK"); ?>',
                    loaderBg: '#5ba035',
                    hideAfter: 1500
                });
                break;
            case 'info':
                $.extend(options, {
                    heading: '<?php echo app('translator')->get("Info"); ?>',
                    loaderBg: '#3b98b5',
                    hideAfter: 2000
                });
                break;
            case 'warning':
                $.extend(options, {
                    heading: '<?php echo app('translator')->get("Upozorenje"); ?>',
                    loaderBg: '#da8609',
                    hideAfter: 3000
                });
                break;
            case 'error':
                $.extend(options, {
                    heading: '<?php echo app('translator')->get("Greška"); ?>',
                    loaderBg: '#bf441d',
                    hideAfter: 15000
                });
                break;
            default:
                $.extend(options, {
                    heading: '<?php echo app('translator')->get("Obaveštenje"); ?>',
                    loaderBg: '#1ea69a',
                    hideAfter: 1500
                });
                break;
        }


        $.toast(options);
    }
    
    <?php if (! (empty($message = request()->getSystemMessage()))): ?>
        showSystemMessage("<?php echo addslashes($message['text']); ?>", "<?php echo e($message['type']); ?>");
    <?php endif; ?>
</script>
<!-- end:system-message rendering script-->
<?php /**PATH /home/drventar/vd-trans.com/fakture/resources/views/_layout/partials/system_messages.blade.php ENDPATH**/ ?>